/*
 * Extrapolator.java
 *
 * Created on August 3, 2004, 1:35 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** implements an extrapolation calculation routine for a vector
 *  function.
 *  Based on routines pzextr and rzextr from Numerical Recipes section 16.4.
 *  Takes a series of doubles, x and corresponding Vec values, y,
 *  and extrapolates down to a target x.
 *  @author  Daniel Wachsstock
 */
public interface Extrapolator {
    /** add a new data set to the extrapolation
     *  @param x the input x value
     *  @param y the input y value. On return, is updated to
     *  the value of y extrapolated to x == target X.
     *  @param dy on output, updated to the error estimate in each element of y.
     *  If dy == null, then is ignored.
     */
    void add (double x, Vec y, Vec dy);
    
    /** change the target
     *  @param x the new target x
     */
    void setTarget (double x);
    
    /** the target x value
     *  @return the target
     */
    double getTarget();
    
    /** reset the extrapolation (discard all previous points)
     */
    void reset();
} // Extrapolator

