/*
 * Mat.java
 *
 * Created on July 18, 2004, 9:39 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** based on the Matrix template from Numerical Recipes.
 *  Abstracts a square vector of vectors of double
 *
 * @author  Daniel Wachsstock
 */
public interface Mat {

    /** the size of the matrix
     *  @return the size of the square matrix
     */
    int size();
    
    /** get an individual element
     *  @param i the row
     *  @param j the column
     *  @return the value at i,j
     */
    double get (int i, int j);
    
    /** get a row
     *  @param i the row
     *  @return the actual row, or a Vec whose
     *  changes are reflected in the original matrix
     */
    Vec getRow (int i);

    /** get a column
     *  @param i the column
     *  @return the actual column, or a Vec whose
     *  changes are reflected in the original matrix
     */
    Vec getColumn (int i);
    
    /** set an individual element 
     *  @param i the row
     *  @param j the column
     *  @param d the value to set it to
     *  @throws UnsupportedOperationException if the vector is immutable
     */
    void set(int i, int j, double d);

    /** return a copy of this, or some version that the user can manipulate at will.
     *  If the implementation of this is immutable, can return the original, or the
     *  implementation can do some kind of copy-on-write.
     *  @return a copy of the data
     */
    Mat copy();

    /** get the data
     *  @return the data as a double[][]
     */
    double[][] asArray();

} // Mat
