/* MatDecomposition.java
 * created 7/21/2004
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** represents a decomposition of a matrix so that it can be used to solve
 *  linear equations. Thus to solve AX = B, where A is a Mat and B is a Vec
 *  of the same size, and X is the unknown Vec,
 *  use MatDecomposition decomp = new ConcreteMatDecomposition(A);
 *  where ConcreteMatDecomposition implements MatDecomposition. For most
 *  algorithms, the constructor will destroy the original Mat and use it
 *  to store the decomposition. See Numerical Recipes, chapter 2
 *  To actually solve the equation, use decomp.solve(B). See
 *  {@link #solve(Vec)}.
 *  This will replace B by the solution X (B is destroyed).
 *  To get the inverse of the original matrix, use {@link #inverse()}
 *  this returns a new Mat that is the inverse of the original A;
 *
 *  @author Daniel Wachsstock
 */
public interface MatDecomposition {
    /* Solve the linear equation AX=B, where A is the Mat used in the
     * constructor.
     * @param B the Vec to use as the right-hand side of the equation.
     * Its contents are replaced by the solution vector.
     * @returns B
     * @throws IndexOutOfBoundsException if B is smaller than A
     */
    Vec solve(Vec B);

    /* find the inverse of the original Mat A
     * @returns the inverse
     */
     Mat inverse();

} // MatDecomposition