/*
 * MatMath.java
 *
 * Created on July 22, 2004, 10:47 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** basic functions for vector and matrix math
 *  not particularly efficient--they allocate a lot of
 *  objects that are promptly deallocated
 *
 * @author  Daniel Wachsstock
 */
public class MatMath {
    
    /** Cannot be instantiated */
    private MatMath() {
    }
    
    /** result = a + b */
    static public Vec add (Vec a, Vec b){
        Vec result = new Vec_array(a.size());
        for (int i = 0; i < a.size(); i++) result.set(i, a.get(i)+b.get(i));
        return result;
    }

    /** result = d * a */
    static public Vec mul (double d, Vec a){
        Vec result = new Vec_array (a.size());
        for (int i = 0; i < a.size(); i++) result.set(i, a.get(i)*d);
        return result;
    }

    /** result = inner product of a and b. */
    static public double dot (Vec a, Vec b){
        double result = 0;
        for (int i = 0; i < a.size(); i++) result += a.get(i)*b.get(i);
        return result;
    }
    
    /** result = a + b */
    static public Mat add (Mat a, Mat b){
        Mat result = new Mat_array (a.size());
        for (int i = 0; i < a.size(); i++)
            result.getRow(i).set( add (a.getRow(i), b.getRow(i)));
        return result;
    }
    
    /** result = d * a */
    static public Mat mul (double d, Mat a){
        Mat result = new Mat_array (a.size());
        for (int i = 0; i < a.size(); i++)
            result.getRow(i).set (mul (d,a.getRow(i)));
        return result;
    }
    
    /** result = a * b */
    static public Vec mul (Mat a, Vec b){
        Vec result = new Vec_array (a.size());
        for (int i = 0; i < a.size(); i++) result.set (i, dot (a.getRow(i), b));
        return result;
    }
    
    /** result = a * b */
    static public Vec mul (Vec a, Mat b){
        Vec result = new Vec_array(a.size());
        for (int i = 0; i < a.size(); i++) result.set (i, dot (b.getColumn(i), a));
        return result;
    }
    
    /** result = a * b */
    static public Mat mul (Mat a, Mat b){
        Mat result = new Mat_array (a.size());
        for (int i = 0; i < a.size(); i++){
            for (int j = 0; j < a.size(); j++){
                result.set (i,j, dot (a.getRow(i), b.getColumn(j)));
            }
        }
        return result;
    }

    /** result = transpose (a) */
    static public Mat transpose (Mat a){
        Mat result = new Mat_array (a.size());
        for (int i = 0; i < a.size(); i++){
            for (int j = 0; j < a.size(); j++){
                result.set (i,j, a.get (j, i));
            }
        }
    return result;
    }
    
    /** result = sum ( abs(elements (v))) */
    static public double norm1 (Vec v){
        double result = 0;
        for (int i = 0; i < v.size(); i++){
            result += Math.abs(v.get(i));
        } // for
        return result;
    } // norm1
    
    /** result = sqrt (sum (elements (v) ^2)) */
    static public double norm2 (Vec v){
        double result = 0;
        for (int i = 0; i < v.size(); i++){
            double x = v.get(i);
            result += x*x;
        } // for
         return Math.sqrt(result);
    } // norm2
    
    /** result = max ( abs(elements (v))) */
    static public double normInf (Vec v){
        double result = 0;
        for (int i = 0; i < v.size(); i++){
            double x = Math.abs(v.get(i));
            if (x > result) result = x;
        } // for
        return result;
    } // normInf
    
    /** test suite */
    public static void main (String[] args){
        int n = 5;
        Mat I = Mat_array.identity(n);
        for (int count = 0; count < 5; count++){
            Mat a = new Mat_array (n);
            for (int i = 0; i < n; i++) for (int j = 0; j < n; j++){
                a.set (i,j, Math.random() * (i+10));
            }
    //        a = add (I, a); 
            a.set (1, 1, 0);
            Mat b = a.copy();
            SingularValueDecomposition id = new SingularValueDecomposition (b);
            System.out.println(a);
            System.out.println(b);
            System.out.println(id.getS());
//            // find the inverse
//            Mat result = id.getS();
//            // find the inverse of S
//            for (int i = 0; i < result.size(); i++) result.set (i, i, 1d/result.get(i,i));
//            result = mul (id.getV(), result);
//            // the inverse of U is transpose (U)
//            result = mul (result, transpose (id.getU()));
//            System.out.println (isIdentity(mul (result, a)));
//            System.out.println (isIdentity(mul (a, result)));
//            System.out.println(result);
            System.out.println (isIdentity(mul (id.inverse(), a)));
            System.out.println (isIdentity(mul (a, id.inverse())));
        }
    }
    
    public static boolean isIdentity(Mat A){
        Mat I = Mat_array.identity(A.size());
        for (int r = 0; r < A.size(); r++) for (int c = 0; c < A.size(); c++)
            if (Math.abs (I.get(r,c) - A.get(r,c)) > 1e-8) return false;
        return true;
    }
}

