/*
 * Mat_wrapper.java
 *
 * Created on August 25, 2005
 *
 *  Copyright 2005 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** Implements a simple Mat based on a based on an external array.
 *  The underlying data is publicly available.
 *
 *  @author  Daniel Wachsstock
 */
public class Mat_wrapper implements Mat {
    /** the array underlying this Mat */
    final public double[][] data;
    
    /** Creates a new instance of Mat_array.    
     *  @param d the array to use
     *  @throws IndexOutOfBoundsException if d is not a square array
     */
    public Mat_wrapper (double[][] d){
        data = d;
    } // constructor
        
    public double[][] asArray() {
        double[][] result = (double[][]) data.clone();
        for (int i = 0; i < data.length; i++)
            result[i] = (double[]) data[i].clone();
        return result;
    }
    
    public Mat copy() {
        return new Mat_array(data);
    }
    
    public double get(int i, int j) {
        return data[i][j];
    }
    
    public Vec getColumn(int j) {
        return new ColumnSlice(j);
    }
    
    public Vec getRow(int i) {
        return new RowSlice(i);
    }
    
    public void set(int i, int j, double d) {
        data[i][j] = d;
    }
    
    public int size() {
        return data.length;
    }
    
    public String toString(){
        String result = "{";
        for (int i = 0; i < data.length; i++){
            if (i > 0) result += ", ";
            result += getRow(i).toString();
        } // for
        return result+"}";
    }// toString

    
    class RowSlice implements Vec {
        private int _i;
        
        public RowSlice(int i) {_i = i;}      
        
        public double[] asArray() {
            return (double[])data[_i].clone();
        }
        
        public nr.Vec copy() {
            return new Vec_array(data[_i]);
        }
        
        public double get(int i) {
            return data[_i][i];
        }
        
        public void set(int i, double d) {
            data[_i][i] = d;
        }
        
        public void set (double[] d){
            for (int i = 0; i < d.length; i++) set(i, d[i]);
        }
        
        public void set(Vec v) {
            for (int i = 0; i < v.size(); i++) set(i,v.get(i));
        }

        public int size() {
            return data.length;
        }
 
    public String toString(){
        String result = "{";
        for (int i = 0; i < data.length; i++){
            if (i > 0) result += ", ";
            result += data[_i][i];
        } // for
        return result+"}";
    }// toString
       
    } // RowSlice
    
    class ColumnSlice implements Vec {
        private int _j;
        
        public ColumnSlice (int j) {_j =j ;}
        
        public double[] asArray() {
            double[] result = new double[data.length];
            for (int i = 0; i < result.length; i++)
                result[i] = data[i][_j];
            return result;
        }
        
        public nr.Vec copy() {
            return new Vec_array (asArray());
        }
        
        public double get(int i) {
            return data[i][_j];
        }
        
        public void set(int i, double d) {
            data[i][_j] = d;
        }
 
        public void set(double[] d) {
            for (int i = 0; i < d.length; i++) set(i, d[i]);
        }

        public void set(Vec v) {
            for (int i = 0; i < v.size(); i++) set(i,v.get(i));
        }
        
        public int size() {
            return data.length;
        }

    public String toString(){
        String result = "{";
        for (int i = 0; i < data.length; i++){
            if (i > 0) result += ", ";
            result += data[i][_j];
        } // for
        return result+"}";
    }// toString
                
    }
}
