/*
 * Vec.java
 *
 * Created on June 8, 2004, 10:59 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** based on the vector template of Numerical Recipes.
 *  abstracts a vector of doubles
 *
 * @author  Daniel Wachsstock
 */
public interface Vec {
    /** the size of the vector */
    int size();

    /** the i-th element */
    double get(int i);
 
   /** set the i-th element 
    *  @param i the element to set
    *  @param d the value to set it to
    *  @throws UnsupportedOperationException if the vector is immutable
    */
    void set(int i, double d);

    /** Copy the vector from an array
     *  @param d the array to copy from
     *  @throws UnsupportedOperationException if the vector is immutable
     */
    void set (double[] d);

    /** Copy the vector from an array
     *  @param v the vector to copy from
     *  @throws UnsupportedOperationException if the vector is immutable
     */
    void set (Vec v);
    
    
    /** return a copy of this, or some version that the user can manipulate at will.
     *  If the implementation of this is immutable, can return the original, or the
     *  implementation can do some kind of copy-on-write.
     *  @return a copy of the data
     */
    Vec copy();
 
   /** get the data
     * @return the data as a double[]
     */
    double[] asArray();
} // Vec
