/*
 * Vec_array.java
 *
 * Created on June 8, 2004, 11:04 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** Implements a simple Vec based on a fixed array
 *
 * @author  Daniel Wachsstock
 */
public class Vec_array implements Vec {
    private final double[] _data;

    /** Creates a new instance of Vec_array.
     *  @param size the number of dimensions of this vector*/
    public Vec_array(int size) {
        _data = new double[size];
    } // constructor

    /** Creates a new instance of Vec_array by <i>copying</i>
     *  the input array
     *  @param data the array to copy
     */
    public Vec_array(double[] data){
        _data = (double []) data.clone();
    } // constructor
    
    /** Copy-creates a new instance of Vec_array.
     *  @param v the vector to copy
     */
    public Vec_array(Vec_array v){
        _data = (double[]) v._data.clone();
    } // constructor
    
    /** Copy-create a new instance of Vec_array.
     *  Less efficient than {@link #Vec_array(Vec_array)}
     *  since it uses the interface to get elements
     *  @param v the vector to copy
     */
    public Vec_array(Vec v){
        _data = v.asArray();
    } // constructor
    
    public double get(int i) {
        return _data[i];
    }
    
    public void set(int i, double d) {
        _data[i] = d;
    }
    
    public void set (double[] d){
        for (int i = 0; i < d.length; i++) _data[i]=d[i];
    }
    
    public void set (Vec v) {
        for (int i = 0; i < v.size(); i++) _data[i]=v.get(i);
    }
    
    public int size() {
        return _data.length;
    }
    
    public Vec copy() {
        return new Vec_array(this);
    }
    
    public double[] asArray() {
        return (double[]) _data.clone();
    }

    public String toString(){
        String result = "{";
        for (int i = 0; i < _data.length; i++){
            if (i > 0) result += ", ";
            result += _data[i];
        } // for
        return result+"}";
    }// toString
 
} // Vec_array
