/*
 * Vec_wrapper.java
 *
 * Created on August 25, 2005, 11:04 PM
 *
 *  Copyright 2005 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr;

/** Implements a simple Vec based on an external array.
 *  The underlying data is publicly available
 *
 *  @author  Daniel Wachsstock
 */
public class Vec_wrapper implements Vec {
    /** the data underlying this Vec */
    public final double[] data;

    /** Creates a new instance of Vec_wrapper
     *  @param array the array to use
     */
    public Vec_wrapper(double[] array){
        data = array;
    } // constructor
    
    public double get(int i) {
        return data[i];
    }
    
    public void set(int i, double d) {
        data[i] = d;
    }
    
    public void set (double[] d){
        for (int i = 0; i < d.length; i++) data[i]=d[i];
    }
    
    public void set (Vec v) {
        for (int i = 0; i < v.size(); i++) data[i]=v.get(i);
    }
    
    public int size() {
        return data.length;
    }
    
    public Vec copy() {
        return new Vec_array(data);
    }
    
    public double[] asArray() {
        return (double[]) data.clone();
    }

    public String toString(){
        String result = "{";
        for (int i = 0; i < data.length; i++){
            if (i > 0) result += ", ";
            result += data[i];
        } // for
        return result+"}";
    }// toString
 
} // Vec_wrapper
