/*
 * Minimizer.java
 *
 * Created on October 26, 2004, 10:19 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr.minimizer;
import nr.*;

/** minimizes a function of a scalar.
 *  The constructor of an implementation will most likely take a {@link
 *  #Function} to minimize and the implementation will simply implement the
 *  algorithm, or the function to minimize may be hard-wired.
 *  @author  Daniel Wachsstock
 */
interface Minimizer {
    /** minimize a function with an initial guess and a secondary guess. The
     *  secondary guess sets the scale for searching and bisecting or expanding the
     *  range. Thus minimize (1, 2) uses an initial guess of 1 for the independent variable
     *  and then tries 2 and points around there. minimize (1, 1.0001) would use the same
     *  initial guess but would start searching a much smaller range. The method should try
     *  to expand or constrict the range no matter what the secondary guess is.
     *  <br/>
     *  The method only guarrantees to find a local minimum.
     *  @param d1 the initial guess for the dependent variable.
     *  @param d2 the secondary guess.
     *  @param func the function to minimize (uses func.eval());
     *  @return the value of the dependent variable at the minimum.
     *  @throws DidNotConvergeException if no minimum could be found.
     *  @throws IllegalArgumentException if d1 == d2.
     */
    public abstract double minimize (double d1, double d2);

    /** the value of the function at the minimum.
     *  @return the value of the function at the calculated minimum.
     *  Not defined if minimize has not been called
     */
    public double lastF();

} // Minimizer
