/*
 * VecMinimizer.java
 *
 * Created on October 26, 2004, 10:19 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package nr.minimizer;
import nr.*;

/** minimizes a function of a Vec. The constructor will likely take a
 *  {@link #nr.ScalarFunction}
 *  and the implementation will simply implement an algorithm, or the
 *  implementation can specify both.
 *  @author  Daniel Wachsstock
 */
public interface VecMinimizer{
    /** minimizes a function.
     *  @param v the initial guess for the function. On return, is set
     *  to the local minimum.
     *  @return the value of the function at v
     *  @throws nr.DidNotConvergeException if no minimum could be found.
     */
    public double minimize (Vec v);
    
   /** the number of function evaluations it took to converge to the minimum.
    *  @return the number of function evaluations.
    */
   public int numFuncEvals();
   
    /** set the desired relative accuracy parameter. Each
     *  implementation decides how to interpret this, if at all
     */
    public void setEpsilon (double epsilon);
    
    /** return the relative accuracy parameter
     */
    public double getEpsilon ();

} // VecMinimizer
