/*
 * BulirschStolerODE.java
 *
 * Created on August 1, 2004, 10:11 PM
  *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
*/

package nr.ode;
import nr.*;

/** the real Bulirsch-Stoer algorithm, as given in Numerical Recipes.
 *  Uses a MidpointODE as the slave and polynomial extrapolation for 
 *  the extrapolator. The classic Bulirsch-Stoer algorithm used rational
 *  function extrapolation, but was otherwise the same.
 */
class BulirschStoerODE extends AbstractBulirschStoerODE {
    
    public BulirschStoerODE (VecFunction dxdt){
        super (dxdt);
        _slaveODE = new MidpointODE (dxdt);
        _extrapolator = new PolynomialExtrapolator (numEpsilons());
    } // constructor

    protected double cost (double epsilon){
        // would take 1/epsilon substeps, each with one call to _dxdt.eval
        // plus the time = 0 call
        return 1/epsilon + 1;
    }
    
    protected double substepEpsilon (int j){
        return 1d/(2*j+2);
    } // substepEpsilon

    // optimal maximum per Numerical Recipes
    protected int numEpsilons() { return 7; }

    public static String name(){
        return "Bulirsch-Stoer";
    }
    
    public static String description(){
        return "Tries a modified-midpoint method multiple times with " +
        " increasing accuracy and extrapolates"+
        " to infinite accuracy";
    }
} // BulirschStoerODE

