// the simplest ODE solver; Euler's 
/** Euler--the simplest solver.
 *  a constant stepsize of eps * endT, with one function evaluation per step
 *  The Euler method from Numerical Recipes
 */
package nr.ode;
import nr.*;
class Euler extends ODE{

    private double _stepSize;

    public Euler (VecFunction dxdt){
        super (dxdt);
    }
    
    // set _stepsize then solve
    public void solve (Vec x, final double endT)
      throws DidNotConvergeException{
        _stepSize = _eps * endT;
        super.solve (x, endT);
    } // solve

    public void solve (Vec x, double[] h)
      throws DidNotConvergeException{
        _stepSize = _eps * h[1];
        super.solve (x, h[1]); // always goes the distance
        h[0] = h[1];
    } // solve
    
    void solveStep(Vec x, Vec dxdt, double[] h, Vec scale) throws DidNotConvergeException {
        if (_stepSize > 0){
            h[1] = Math.min (h[1], _stepSize);
        }else{
            h[1] = Math.max (h[1], _stepSize);
        }
        for (int i = 0; i < x.size(); i++)
            x.set (i, x.get(i) + h[1] * dxdt.get(i));
    } // solveStep

    public static String name() { return "Euler's method"; }
    public static String description(){
        return "The simplest integrator.  Divides each step into " +
          "1/epsilon sub-steps, so if epsilon = 0.1 then it takes " +
          "10 substeps. " +
          "Assumes the derivative is constant over the whole substep.";
    }// description

} // Euler
