/** FluxTolerance--the algorithm from Barshop's KINSIM
  * each step size is adjusted so that dxdt*step size / x <= eps for all x
  * (where x and dx != 0).
  */
package nr.ode;
import nr.*;
class FluxTolerance extends ODE{

    public FluxTolerance (VecFunction dxdt){
        super (dxdt);
    }

    void solveStep(Vec x, Vec dxdt, double[] h, Vec scale) throws DidNotConvergeException {
        if (h[1] > 0){
            h[1] = Math.min (_eps / maxRatio(dxdt,x,0d), h[1]);
        }else{
            h[1] = Math.max (_eps / maxRatio(dxdt,x,0d), h[1]);
        }
        for (int i = 0; i < x.size(); i++)
            x.set (i, x.get(i) + h[1] * dxdt.get(i));
    } // solveStep

    public static String name() {return "Flux Tolerance";}
    public static String description(){
        return "The method from the original Barshop and Frieden KINSIM. "+
          "Sets the substep size such that no " +
          "item changes by more than epsilon.";
    } // description
    
} // FluxTolerance
