/*
 * HelpWindow.java
 *
 * Created on August 4, 2005, 5:16 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.gui;

import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

/** Displays the About&hellip; screen for Tenua
 *
 * @author Daniel Wachsstock
 */
public class AboutWindow 
  extends javax.swing.JFrame 
  implements ActionListener {

    static final private JEditorPane _pane = new JEditorPane();
    static final private JButton _close = 
      new JButton (util.Resources.getString("Manual.close"));
    static private AboutWindow _singleton = new AboutWindow();

    /** Creates a new instance of HelpWindow; private to enforce the Singleton
     *  pattern
     */
    private AboutWindow() {
        super(util.Resources.getString("About.line"));
        // pane is the content pane
        java.awt.Container pane = getContentPane();
        pane.setLayout(new java.awt.BorderLayout());
        // About
        JPanel aboutPanel = new JPanel();
        aboutPanel.add (new JLabel (util.Resources.getString("About.text")));
        pane.add (aboutPanel, java.awt.BorderLayout.NORTH);
        // license
        _pane.setEditable(false);
        loadLicense();        
        pane.add(new JScrollPane(_pane), java.awt.BorderLayout.CENTER);
        // copyright line and close button
        JPanel pane1 = new JPanel();
        pane1.add(new JLabel(util.Resources.getString("About.copy")));
        pane1.add(_close);
        pane.add(pane1, java.awt.BorderLayout.SOUTH);
        setSize (700,500);
        _close.addActionListener(this);
    } // constructor
    
    static public void about(){
        _singleton.setVisible(true);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == _close){
            setVisible(false);
        } // if
    } // actionPerformed

    private void loadLicense(){
        String location = util.Resources.resourceDir +
          util.Resources.getString("License.file");
        // get resources from the top of the classpath
        java.net.URL url = ClassLoader.getSystemResource(location);
        try{
            _pane.setPage (url);
        }catch (Throwable t){
            util.ErrorDialog.errorDialog("About.CannotShow",t);
        } // try
    } // loadManual
} // AboutWindow
