/*
 * HelpWindow.java
 *
 * Created on August 4, 2005, 5:16 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.gui;

import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

/** Displays the manual for Tenua
 *
 * @author Daniel Wachsstock
 */
public class HelpWindow 
  extends javax.swing.JFrame 
  implements HyperlinkListener, ActionListener {

    static final private JEditorPane _pane = new JEditorPane();
    static final private JButton _back =
      new JButton (util.Resources.getString("Manual.back"));;
    static final private JButton _close = 
      new JButton (util.Resources.getString("Manual.close"));
    static private HelpWindow _singleton = new HelpWindow();

    /** Creates a new instance of HelpWindow; private to enforce the Singleton
     *  pattern
     */
    private HelpWindow() {
        super(util.Resources.getString("Manual.title"));
        // pane is the content pane
        java.awt.Container pane = getContentPane();
        pane.setLayout(new java.awt.BorderLayout());
        // HTML viewer pane
        _pane.setEditable(false);
        _pane.addHyperlinkListener(this);
        loadManual();
        pane.add(new JScrollPane(_pane), java.awt.BorderLayout.CENTER);
        // button panel
        JPanel pane1 = new JPanel();
        pane.add(pane1, java.awt.BorderLayout.SOUTH);
        pane1.add(_back);
        pane1.add(_close);
        setSize (700,500);
        _back.addActionListener(this);
        _close.addActionListener(this);
    } // constructor
    
    static public void showHelp(){
        _singleton.setVisible(true);
    }

    /** process hyperlinks; from the JEditorPane source code */
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            // Note: this handles frames incorrectly. That is intentional;
            // this isn't intended to be a web browser
            try{
                _pane.setPage(e.getURL());
            }catch (Throwable t) { /*ignore*/} // try
        } // if
    } // hyperlinkUpdate
    
    public void actionPerformed(ActionEvent e) {
        if(e.getSource() == _back) {
            loadManual();
        }else if (e.getSource() == _close){
            setVisible(false);
        } // if
    } // actionPerformed

    private void loadManual(){
        String location = util.Resources.resourceDir +
          util.Resources.getString("Manual.file");
        // get resources from the top of the classpath
        java.net.URL url = ClassLoader.getSystemResource(location);
        try{
            _pane.setPage (url);
        }catch (Throwable t){
            util.ErrorDialog.errorDialog("Manual.CannotShow",t);
        } // try
    } // loadManual
} // HelpWindow
