/*
 * MechanismTextField.java
 *
 * Created on July 9, 2004, 2:20 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.gui;
import tenua.simulator.Mechanism;

/** Implements a TextField that reflects a variable in a mechanism
 *
 * @author  Daniel Wachsstock
 */
public class MechanismTextField extends DoubleTextField {
    private final Mechanism _parent;
    private final boolean _isInitial;
    
    /** Creates a new instance of MechanismTextField */
    public MechanismTextField (Mechanism parent, String name, boolean isInitial) {
        super (name, isInitial ? parent.getInitial(name) : parent.getLatest(name));
        _parent = parent;
        _isInitial = isInitial;
        addPropertyChangeListener(name, this);
    }
    
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt); // change the text
        double d = ((Number) evt.getNewValue()).doubleValue();
        if (_isInitial) _parent.putInitial(getName(), d);
        else _parent.putLatest(getName(), d);
        repaint();
    }
    
    // this only updates the values when repainting, so we catch the paint call
    protected void paintComponent (java.awt.Graphics g){
        String name = getName();
        setValue(_isInitial ? _parent.getInitial(name) : _parent.getLatest(name));
        super.paintComponent(g);
    }
}
