/*
 * PlotterPanel.java
 *
 * Created on May 25, 2004, 3:14 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.gui;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import javax.swing.*;

/** Creates a panel that plots the data in a Tenua
 *
 * @author  Daniel Wachsstock
 */
public class PlotterPanel extends JPanel {
    private final Tenua _parent;
    private final GraphPanel _graph;
    
    /** Creates a new instance of PlotterPanel , tied to the given Tenua window */
    public PlotterPanel(Tenua parent) {
        super();
        setLayout(new BorderLayout());
        _parent = parent;
        getActionMap().setParent(_parent.getActionMap());
        _graph = new GraphPanel(_parent);
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(new DoubleTextField(GraphPanel.TMIN,_graph));
        buttonBox.add(new DoubleTextField(GraphPanel.TMAX,_graph));
        buttonBox.add(new DoubleTextField(GraphPanel.XMIN,_graph));
        buttonBox.add(new DoubleTextField(GraphPanel.XMAX,_graph));
        buttonBox.add(new PropertyCheckBox(GraphPanel.ADJUST_AXES, _graph));
        JButton button = new JButton(util.Resources.getString("Axes.optimizeAxes"));
        button.addActionListener(new ActionListener(){
            public void actionPerformed (java.awt.event.ActionEvent e){
                try{
                    _graph.optimizeAxes();
                }catch (InterruptedException ex) {/* do nothing */}
            } // actionPerformed
        });
        buttonBox.add(button);
        JSplitPane splitPane = new JSplitPane
         (JSplitPane.HORIZONTAL_SPLIT, _graph, buttonBox);
        splitPane.setOneTouchExpandable (true);
        splitPane.setResizeWeight (1.0); // expand the graph, not the buttons
        add(splitPane);

        loadSpecificActions();

    } // constructor

    // adds appropriate actions to this action map
    private void loadSpecificActions(){
        final ActionMap map = this.getActionMap();

        // PRINT
        map.put (ActionType.PRINT, new javax.swing.AbstractAction(){
            public void actionPerformed (java.awt.event.ActionEvent e){
                util.ComponentPrinter job = new util.ComponentPrinter
                  (_graph, TenuaAction.getFormat(_parent));
                job.start();
            } // actionPerformed
        }); // map.put

    } // loadSpecificActions 
}
