/*
 * PropertyCheckBox.java
 *
 * Created on July 8, 2004, 10:59 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.gui;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;


/** Implements a JCheckBox that follows a JComponent property.
 *  The property must be a Boolean
 *
 * @author  Daniel Wachsstock
 */
public class PropertyCheckBox extends JCheckBox implements PropertyChangeListener, ItemListener {
    private JComponent _source;
    
    /** Creates a new instance of PropertyCheckBox
     *  @param name the name of the check box, which is also the key to the property */
    public PropertyCheckBox (String name, JComponent source) {
        super (name,((Boolean)source.getClientProperty(name)).booleanValue());
        super.setName(name); // super(text) just sets the visible text, not the name
        _source = source;
        _source.addPropertyChangeListener(name, this);
        addItemListener(this);
    }
     /** Cannot set the name, since it is tied to the source property */
    public void setName (String name) {}
   
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        if (evt.getNewValue().equals(evt.getOldValue())) return;
        setSelected (((Boolean)evt.getNewValue()).booleanValue());
    }
    
    
    public void itemStateChanged(java.awt.event.ItemEvent e) {
        _source.putClientProperty(getName(), new Boolean(isSelected()));
    }
    
}
