/*
 * AbstractDataGenerator.java
 *
 * Created on June 8, 2004, 10:36 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.simulator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/**
 *
 * @author  Daniel Wachsstock
 */
public class AbstractDataGenerator implements DataGenerator {
    private final Vector _listeners = new Vector();
    protected final List _names;
    
    /** Creates a new instance of AbstractDataGenerator with one output */
    public AbstractDataGenerator() {
        this(0);
    }

    /** Creates a new instance of AbstractDataGenerator
    *   @param n the number of outputs
    */
    public AbstractDataGenerator(int n) {
        _names = new Vector(n);
        for (int i = 0; i < n; i++) _names.add("");
    }

    /** Creates a new instance of AbstractDataGenerator
    *   @param names the names of the outputs
    */
    public AbstractDataGenerator(List names) {
        _names = names;
    }

    /** restart a generation. Calls each listener with DataGenerator.Listener.startingUp(). 
     * @throws UnsupportedOperationException if memento != null
     */
    public void start(Object memento) {
        if (memento != null) throw new UnsupportedOperationException(this.getClass() + " has no mementos");
        fireStartingUp();
        generateData();
        fireDone();
    } // start
    
    /** returns a memento for this DataGenerator. Not supported.
     *  @throws UnsupportedOperationException
     */
    public Object getMemento() {
        throw new UnsupportedOperationException(this.getClass() + " has no mementos");
    }
    
    public List getNames() {
        return  _names;
    }

    public void addListener(DataGenerator.Listener listener) {
        _listeners.add(listener);
    }
   
    public void removeListener(DataGenerator.Listener listener) {
        _listeners.remove(listener);
    }
    
    /** run the data generator, in a form suitable for putting in a Thread */
    public void run(){
        this.start(null);
    } // run

    protected void fireStartingUp(){
        for (Iterator i = _listeners.iterator(); i.hasNext();){
            ((DataGenerator.Listener) i.next()).startingUp(this);
        } // for        
    } // fireStartingUp
    
    protected void generateData(){
        // a real data generator would do something
    } // generate data
    
    // sends a copy of the data to each listener
    protected void fireNewData(nr.Vec data){
         for (Iterator i = _listeners.iterator(); i.hasNext();){
            ((DataGenerator.Listener) i.next()).newData(this,data.copy());
        } // for                       
    }

    protected void fireDone(){
         for (Iterator i = _listeners.iterator(); i.hasNext();){
            ((DataGenerator.Listener) i.next()).done(this);
        } // for               
    }

}
