/*
 * StringDataGenerator.java
 *
 * Created on June 8, 2004, 10:36 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.simulator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/** A {@link DataGenerator} that parses a String consisting of
 *  "\n"-delimited lines, with ";" delimited fields.
 *  The first line is the names, the rest of the lines are the values 
 *
 * @author  Daniel Wachsstock
 */

public class StringDataGenerator extends AbstractDataGenerator {
    private final String _s;
    static final String newLine = "\r\n|\r|\n"; // CrLf pattern
    // would "?m$" work?--no, the line terminator would be included in the next line

    /** Creates a new instance of StringDataGenerator
     *  @param s the string to parse
     *  @throws IllegalArgumentException if s is null
     */
    public StringDataGenerator (String s){
        if (s == null) throw new IllegalArgumentException();
        _s = s;
        String[] strings = _s.split(newLine,2);
        String[] names = strings[0].split("\t");
        for (int i = 0; i < names.length; i++) _names.add(names[i]);
    } // constructor

    protected void generateData(){
        String[] strings = _s.split(newLine);
        int n = _names.size();
        nr.Vec v = new nr.Vec_array(n);
        for (int string = 1; string < strings.length; string++){
            String[] values = strings[string].split("\t");
            for (int i = 0; i < Math.min(n, values.length); i++){
                try{
                    v.set (i, Double.parseDouble(values[i]));
                }catch (NumberFormatException ex){
                    v.set (i, Double.NaN);
                }
            } // for i
            // fill in the rest of v
            for (int i = values.length; i < n; i++) v.set (i, Double.NaN);
            fireNewData (v);
        } // for string
    } // generate data

} // StringDataGenerator
        
