/*
 * Assignment.java
 *
 * Created on June 25, 2004, 1:50 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;
import java.util.Stack;

/** A Symbol that handles assignment to a variable from the stack
 *
 * @author  Daniel Wachsstock
 */
public class Assignment extends Symbol{
    protected final Variable _v;
    
    /** Creates a new instance of Assignment */
    protected Assignment(Variable v) {
        super();
        _v = v;
    }
    
    /** assigns a value to the stored variable
     *  @param s the stack to pop the value from
     *  @param v the memento to have the variable use
     */
    public void eval(DoubleStack s, VariableMemento v) {
        _v.assign (s.pop(), v);
    }
    
    public Variable getTarget() {return _v;}
    
    public String toString() {return _v.toString()+"=";}
    
    public void toString(Stack stringStack, Stack precedenceStack, SymbolTable st) {
        StringBuffer top = (StringBuffer) stringStack.peek(); // modify in place
        top.insert(0,'=').insert (0,st.lookup(_v));
        // assignment is always the lowest precedence
        precedenceStack.pop();
        precedenceStack.push(new Integer(0));
    } // toString
    
} // Assignement
