/*
 * DoubleStack.java
 *
 * Created on May 13, 2004, 7:58 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;

/** A simple stack of doubles. Until autoboxing is implemented,
 *  it's too hard to keep casting back and forth, using java.util.Stack.
 *  <br>
 *  Is NOT thread-safe.
 *
 * @author  Daniel Wachsstock
 */
public class DoubleStack implements Cloneable {
    private double[] _d; // the values
    private int _size = 0; // the number of values on the stack

    /** construct a new DoubleStack with initial capacity == 10. */
    public DoubleStack(){
        this(10);
    } // constructor

    /** construct a new DoubleStack with initial capacity == capacity.
     *  @param capacity the initial capacity
     */
    public DoubleStack(int capacity){
        if (capacity <= 0) throw new IllegalArgumentException();
        _d = new double[capacity];
    } // constructor

    /** construct a new DoubleStack with given initial values.
     *  @param d the values to load onto the stack. The top of the stack will be
     *  d.get(d.size()-1); the bottom of the stack will be d.get(0);
     */
    public DoubleStack(nr.Vec d){
        _size = d.size();
        _d = new double[_size > 0 ? 2*_size : 10 ];
        for (int i = 0; i < _size; i++){
            _d[i] = d.get(i);
        } // for
    } // constructor

    /** push a value onto the stack.
     *  @param d the value to push
     */
    public void push(double d){
        int capacity = _d.length;
        if (capacity == _size){
            double[] newD = new double[2*capacity];
            System.arraycopy(_d, 0, newD,0, capacity);
            _d = newD;
        } // if
        _d[_size++] = d;
    } // push

    /** pop a value off the stack.
     *  @return the previous top of the stack
     *  @throws EmptyStackException if the stack is empty
     */
    public double pop(){
        if (_size == 0) throw new java.util.EmptyStackException();
        return _d[--_size];
    } // pop();

    /** return the top of the stack without removing it.
     *  @return the top of the stack
     *  @throws EmptyStackException if the stack is empty
     */
    public double peek(){
        if (_size == 0) throw new java.util.EmptyStackException();
        return _d[_size-1];
    } // peek

    /** clear the stack. */
    public void clear(){
        _size = 0;
    } // clear

    /** how may values are in the stack.
     *  @return the size of the stack
     */
    int getSize(){
        return _size;
    } // getSize

    /** return a copy of the numbers in the stack
     *  @return a Vec_array that contains the values in the stack */
    public nr.Vec getValues(){
        nr.Vec result = new nr.Vec_array(_size);
        for (int i = 0; i < _size; i++) result.set(i, _d[i]);
        return result;
    } // getValues

    /** clones the stack */
    public Object clone() throws CloneNotSupportedException {
        Object result = super.clone();
        ((DoubleStack)result)._d = (double [])_d.clone();
        return result;
    } // clone
        
} // DoubleStack    
