/*
 * Interpreted.java
 *
 * Created on June 25, 2004, 1:56 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;
import java.util.Stack;

/** A Symbol that uses the BeanShell interpreter to evaluate itself
 *
 * @author  Daniel Wachsstock
 */
public class Interpreted extends Symbol{
    protected final String _name;
    protected final int _numArgs;
    protected final bsh.Interpreter _interpreter;

    // numargs is the number of arguments to the method, or -1 if a field
    public Interpreted (String name, int numArgs, bsh.Interpreter interpreter){
        _name = name;
        _numArgs = numArgs;
        _interpreter = interpreter;
    } // constructor
    
    /** evaluate this symbol.
     *  @param s the stack from which to pull arguments and to which
     *  to push the result if and only if it is a Number
     *  @param v ignored
     */
    public void eval(DoubleStack s, VariableMemento v) {    
        String evalString = _name;
        switch (_numArgs){
            case -1:
                // a field; no arguments; do nothing
                break;
            case 0:
                evalString += "()";
                break;
            case 1:
                evalString += "(" + s.pop() + ")";
                break;
            default:
                // need to pop the arguments off in reverse order
                String argString = s.pop() + ")";
                for (int i = 1; i < _numArgs; i++){
                    argString = s.pop() + "," + argString;
                } // for
                evalString += "(" + argString;
                break;
        } // switch
        try{
            Object result = _interpreter.eval(evalString);
            if (result instanceof java.lang.Number){
                s.push (((java.lang.Number) result).doubleValue());
            } // if
        }catch (bsh.EvalError ex){
            throw new InterpretedSymbolException(ex);
        } // try
    } // eval
  
    public String toString() { return "@"+_name;}
    
    public void toString(Stack stringStack, Stack precedenceStack, SymbolTable st) {
        StringBuffer name = new StringBuffer('@');
        name.append(_name);
        switch (_numArgs){
            case -1:
                // a field; no arguments; do nothing
                break;
            case 0:
                name.append("()");
                break;
            case 1:
                name.append("(").append(stringStack.pop()).append(")");
                precedenceStack.pop();
                break;
            default:
                // need to pop the arguments off in reverse order
                StringBuffer argString = (StringBuffer) stringStack.pop();
                argString.append(")");
                precedenceStack.pop();
                for (int i = 1; i < _numArgs; i++){
                    argString.insert(0,',').insert(0,stringStack.pop());
                    precedenceStack.pop();
                } // for
                name.append('(').append(argString);
                break;
        } // switch
        stringStack.push(name);
        precedenceStack.push(maxPrecedence);
    }
    
} // Interpreted
