/*
 * Symbol.java
 *
 * Created on June 25, 2004, 1:22 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;
import java.util.Stack;

/** Represents something (numbers, id's, operators)
 *  that can be part of an {@link Expression}
 *
 * @author  Daniel Wachsstock
 */
abstract public class Symbol {
    
    /** Creates a new instance of Symbol */
    protected Symbol() {
    }
    
    /** evaluate the Symbol
     *  @param s the stack from which to pop arguments and to which to
     *  push results
     *  @param v the memento representing the current values of variables.
     *  If v is null, then use the default values
     */
    abstract public void eval (DoubleStack s, VariableMemento v);
    
    /** pushes a StringBuffer that reflects this Symbol, with all its arguments
     *  @param stringStack the stack of StringBuffer from which to pop arguments
     *  and to which to push results
     *  @param precedenceStack a stack to be push'ed and pop'ed in parallel with
     *  stringStack that contains Integers, corresponding to the precedence of 
     *  the arguments onstringStack. This is used to determine placement of 
     *  parentheses. Anything other than a binary operation should push
     *  {@link #maxPrecedence}
     *  @param st the {@link SymbolTable} to get Symbol names from
     *  Note: the name is a misnomer; it uses StringBuffer's, not String's
     */
    public void toString (Stack stringStack, Stack precedenceStack, SymbolTable st){
        stringStack.push(new StringBuffer(toString()));
        precedenceStack.push(maxPrecedence);
    }
    
    /** the maximum precedence. Just Integer.MAX_VALUE */
    static public final Integer maxPrecedence = new Integer(Integer.MAX_VALUE);
    
    // puts parentheses around a StringBuffer, for use with toString
    protected void parenthesize (StringBuffer s){
        s.insert(0,'(').append(')');
    } // parenthesize

    /// static Symbols that anyone can use
    
    /** a Symbol that clears the stack */
    static public final Symbol CLEAR_STACK = new Symbol(){
        public void eval(DoubleStack s, VariableMemento v){
            s.clear();
        }
        public String toString() {return "CLEAR_STACK";}
    };

} // Symbol
