/*
 * UnexpectedSymbolException.java
 *
 * Created on June 25, 2004, 1:09 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;

/** Thrown when the parser finds a Symbol, but one of the wrong type
 *
 * @author Daniel Wachsstock
 */
class UnexpectedSymbolException extends RuntimeException {
    
    /*  Factory method to create new UnexpectedSymbolException's
     *  In order to allow initializing the message with localized information,
     *  we force the user to go through this method.
     *  overriding getMessage would likely work as well, but I wasn't sure
     *  @param name the name of the unexpected symbol
     *  @resource the key in util.Resources for the error message
     */
    static public UnexpectedSymbolException
      instance (String name, String resource){
        final String[] strings = util.Resources.getString(resource).split(";");
        String title = "";
        if (strings.length > 0) title = strings[0];
        String message;
        Object[] o = new Object[1];
        o[0] = name;
        if (strings.length > 1){
            message = java.text.MessageFormat.format(strings[1], o);
        }else{
            message = title;
        }
        return new UnexpectedSymbolException (message);
    } // instance
    
    private UnexpectedSymbolException(String message){
        super(message);
    }
}