/*
 * Value.java
 *
 * Created on June 25, 2004, 1:29 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;
import java.util.Stack;

/** A {@link Symbol} that has a value that can be pushed onto the stack
 *
 * @author  Daniel Wachsstock
 */
public class Value extends Symbol {
    protected double _d; // the value
    
    /** Creates a new instance of Value */
    protected Value(double d) {
        super();
        _d = d;
    }
    
    /** push the value onto the stack
     *  @param s the stack to push onto
     *  @param v ignored
     */
    public void eval(DoubleStack s, VariableMemento v) {
        s.push(_d);
    }

    /** get the value
     *  @param v ignored
     *  @return the value
     */
    public double getValue (VariableMemento v){
        return _d;
    } // getValue
   
    public String toString() {return Double.toString(_d);}
    
    public void toString(Stack stringStack, Stack precedenceStack, SymbolTable st) {
        stringStack.push(new util.Num2Str().format(_d));
        precedenceStack.push(maxPrecedence);
    }
    
    // Static final Values that can be shared
    public static final Value ZERO = new Value(0);
} // Value
