/*
 * Variable.java
 *
 * Created on June 25, 2004, 1:35 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;
import java.util.Stack;

/**  A {@link Symbol} that has a value that can be pushed onto the stack
 *  and can be changed. To allow for different states of the symbol table,
 *  a Variable has a default value but can pull its value from a
 *  {@link VariableMemento}.
 *
 * @author  Daniel Wachsstock
 */
public class Variable extends Value{
    protected final int _i;
    
    /** Creates a new instance of Variable 
     *  @param i the index of this variable into the VariableMemento
     *  assigned by {@link #SymbolTable}
     */
    protected Variable(int i) {
        super(0); // start with default value of 0
        _i = i;
    } // constructor
    
    /** get the value
     *  @param s the stack to push onto
     *  @param v the memento to use. If v == null, use the default value
     */
    public void eval(DoubleStack s, VariableMemento v) {
        if (v == null){
            s.push(_d); // use the default
        }else{
            s.push (v._d[_i]); // get the value from the memento
        } // if
    } // eval
    
    /** get the value
     *  @param v the memento to use. If v==null, use the default value
     *  @return the value
     */
    public double getValue (VariableMemento v){
        if (v == null) return _d;
        else return v._d[_i];
    } // getValue
    
    /** assign a new value
     *  @param d the new value
     *  @param v the memento to use. if v == null, assign to the default value
     */
    public void assign (double d, VariableMemento v){
        if (v == null){
            _d = d; // set the default
        }else{
            v._d[_i] = d;
        }
    } // assign
    
    /** set the value for this variable in a memento to the default
     *  @param v the memento. If v == null, does nothing
     */
    public void reset (VariableMemento v){
        if (v != null) v._d[_i] = _d;
    } // reset
    
    // Variables don't know their own names, just the value
    public String toString() {return "Variable[" + _i + "]:" + super.toString();}

    public void toString(Stack stringStack, Stack precedenceStack, SymbolTable st) {
        stringStack.push (new StringBuffer(st.lookup(this)));
        precedenceStack.push(maxPrecedence);
    }
} // Variable
