/*
 * VariableMemento.java
 *
 * Created on June 25, 2004, 1:25 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package tenua.symbol;

/** A memento that stores the state of a {@link SymbolTable}'s variables
 *
 * @author  Daniel Wachsstock
 */
public class VariableMemento{
    
    // the values of each variable
    protected final double[] _d;
    
    /** Creates a new instance of VariableMemento;
     *  not for public use. To be used by {@link #SymbolTable} */
    protected VariableMemento(int n) {
        _d = new double[n];
    }
    
    /** Copy constructor for a memento */
    public VariableMemento (VariableMemento v){
        _d = (double[]) v._d.clone();
    }
    
} // VariableMemento
