/*
 * ComponentPrinter.java
 *
 * Created on August 13, 2004, 7:25 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */
package util;

import java.awt.Component;
import java.awt.print.*;

/** Implements a simple printing class for an awtin a Thread.
 *
 * @author  Daniel Wachsstock
 */
public class ComponentPrinter extends Thread implements Pageable, Printable {
   
    private PageFormat _format;
    private Component _c;

    /** Creates a new instance of ComponentPrinter with default PageFormat */
    public ComponentPrinter (Component c) { this(c, null); }

    /** Creates a new instance of StringPrinter
     *  @param c the Component to print
     *  @param format the PageFormat to use; uses PrinterJob.getPrinterJob().defaultPage()
     *  if null
     */
    public ComponentPrinter (Component c, PageFormat format){
        _c = c;
        _format = format;
    } // constructor

    /** prints the Component */
    public void run(){
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        if (_format == null) _format = job.defaultPage();
        job.setPrintable (this);
        if (job.printDialog()){
            try{
                job.print();
            }catch (PrinterException e){
                ErrorDialog.errorDialog("PrintError", e);
            } // try
        } // if
    } // run
    
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex != 0) throw new IndexOutOfBoundsException();
        return _format;
    } // getPageFormat
        
    /** renders a page
     *  @param g the Graphics to render on
     *  @param format the PageFormat to use for rendering
     *  @param pageIndex the page to print
     *  @return NO_SUCH_PAGE or PAGE_EXISTS, as approprite for pageIndex
     *  @throws PrinterException if the component's print() method does
     */
    public int print(java.awt.Graphics g, PageFormat format, int pageIndex)
      throws PrinterException{
    if (_format != format){
            _format = format;
    } // if
    if (pageIndex != 0){
        return Printable.NO_SUCH_PAGE;
    } // if
    _c.print(g.create ((int)_format.getImageableX(), (int)_format.getImageableY(),
      (int)_format.getImageableWidth(), (int)_format.getImageableHeight()));
    return Printable.PAGE_EXISTS;
    }
    
    public int getNumberOfPages() {
        return 1;
    }
    
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex != 0) throw new IndexOutOfBoundsException();
        return this;
    }
    
 // print

} // StringPrinter
