/*
 * ErrorDialog.java
 *
 * Created on June 10, 2004, 11:01 PM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package util;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/** utility class to create dialogs for displaying exceptions.
 *  Cannot be instantiated
 *
 * @author  Daniel Wachsstock
 */
public class ErrorDialog {    
    // cannot be instantiated
    private ErrorDialog() {
    }
 
    /** shows a message.
     *  @param message the string to display
     */
    public static void msgbox (final String message){
        errorDialogLocal ("Program Message", message, null);
    }
    
    /** vshows an error dialog box.
     *  @param resource the key of the string to display, which has the format title;error string
     *  where <code>title</code> is to be the title of the dialog box and <code>string</code> is
     *  the string to display
     *  @param ex the exception to display in the details field
     */
    public static void errorDialog (final String resource, final Throwable ex){
        final String[] strings = Resources.getString(resource).split(";");
        String title = "";
        if (strings.length > 0) title = strings[0];
        String message = "";
        if (strings.length > 1) message = strings[1];
        errorDialogLocal (title, message, ex);
    } // errorDialog

    /** shows an error dialog box, with a customizable message
     *  @param resource the key of the string to display, which has the format title;error string
     *  where <code>title</code> is to be the title of the dialog box and <code>string</code> is
     *  the string to display
     *  @param o the array of objects to insert using MessageFormat
     *  @param ex the exception to display in the details field
     */
    public static void errorDialogSpecific (final String resource, final Object[] o, final Throwable ex){
        final String[] strings = Resources.getString(resource).split(";");
        String title = "";
        if (strings.length > 0) title = strings[0];
        String message = "";
        if (strings.length > 1) message = java.text.MessageFormat.format(strings[1], o);
        errorDialogLocal (title, message, ex);
    } // errorDialog
    
    // shows a dialog box for the given Throwable, with a given title and message
    static protected void errorDialogLocal (final String title, final String message, final Throwable ex){
        final Object[] objects = new Object[3];
        objects[0] = message;
        JLabel err = new JLabel ("<html><hr>" + ex + "</html>");
        err.setPreferredSize(new java.awt.Dimension(500,250));
        objects[1] = err;
        String stack = "";
        if (ex != null) for (int i = 0; i < ex.getStackTrace().length; i++){
            stack += ex.getStackTrace()[i].toString() + "\n";
        } // for
        JScrollPane scroll = new JScrollPane(new JTextArea(stack));
        scroll.setPreferredSize(new java.awt.Dimension(500,250));
        objects[2] = scroll;
        
        javax.swing.SwingUtilities.invokeLater (new Runnable(){
            public void run(){
                JOptionPane.showMessageDialog(null, objects, title, JOptionPane.WARNING_MESSAGE);
            } // run
        }); // invokeLater
    } // errorDialog
    
    
}
