/*
 * Resources.java
 *
 * Created on July 13, 2004, 1:43 AM
 *
 *  Copyright 2004 Daniel Wachsstock
 *  The contents of this file are subject to the Sun Public License
 *  Version 1.0 (the License); you may not use this file except in
 *  compliance with the License. A copy of the License is available at
 *  http://www.sun.com/ or http://www.geocities.com/tenua4java/license.html
 */

package util;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

/** The class that allows access to all the resources of the program
 *
 * @author  Daniel Wachsstock
 */
public class Resources {
    
    /** no one can create a new instance of Resources */
    private Resources() {}
    /** the name of the directory with all the resources */
    public static final String resourceDir = "resources/";
    /** the resource bundle for the whole program */
    public static final ResourceBundle resources = ResourceBundle.getBundle (resourceDir+"strings");
    /** the preference location for all programs that use this class */
    public static final Preferences prefs = Preferences.userNodeForPackage(Resources.class);
    /** call to resources.getString(String */
    public static String getString (String s) {return resources.getString(s);}

}
