/* Generated By:JavaCC: Do not edit this line. MechanismParser.java */
package tenua.parser;
import java.util.Hashtable;
import java.util.List;
import java.util.ArrayList;
import tenua.simulator.Mechanism;
import tenua.simulator.ReactionBlock;
import tenua.symbol.*;

public class MechanismParser implements MechanismParserConstants {
     // fields used in making the mechanism
    private final SymbolTable _st = new SymbolTable();
    private final Expression _calculations = new Expression();
    private final Expression _derivativeCalculations = new Expression();
    private final bsh.Interpreter _interpreter = new bsh.Interpreter();
     // _variableNames is a Hashtable of Lists of Strings, each of
     // which is a list of variables of a given type (output, chemical, etc.)
     // of variables, with the keys being strings
    private final Hashtable _variableNames = new Hashtable();

     // internally used fields
    private StringBuffer _script = new StringBuffer
      ("mechanism.goSimulate();"); /* default script */
    private final Expression _outputExpressions = new Expression();
     // array of Binary Symbols associated with each token. If tokenImage[i]
     // does not represent a binary operation, then _binaries[i] == null
     // I use this for lookahead to determine precedence of binary operators
     // before the parser has a chance to figure them out.
     // The array is loaded by lexical actions by the scanner
     // (see the TOKEN section)
    static final Binary[] _binaries = new Binary [tokenImage.length];
     // these two are Lists of reaction right hand sides and left hand sides,
     // respectively.
     // Each is a list of lists, each of which 
     // consists of pairs Integer, Symbol representing
     // the stoichiometry and species of each reactant
    private final List _rxnRHS = new ArrayList();
    private final List _rxnLHS = new ArrayList();
     // keys to variableNames that are used internally to keep track of
     // which variables have their rates set,
     // and which are derivatives and so need to be added to
     // _derviativeCalculations
    private static final String DERIVATIVES = "$derivative";
    private static final String RATE_SET = "$rate_set";

    static{ // initializer block
        // assign default values that are != 0
        SymbolTable.ensureDefault ("endTime", 10);
        SymbolTable.ensureDefault ("epsilon", 1e-3);
    }  // static initializer

    { // initializer block
        String[] locations =
          util.Resources.getString("Script.Methods").split(";");
        try{
            for (int i = 0; i < locations.length; ++i){
                java.net.URL url = ClassLoader.getSystemResource
                  (util.Resources.resourceDir + locations[i]);
                java.io.Reader reader = new java.io.InputStreamReader
                  (url.openStream());
                _interpreter.eval (reader);
            } // for
        }catch (Exception ex){
            util.ErrorDialog.errorDialog("Script.Error", ex);
        } // try
        // create the time constants
        _st.put ("startTime");
        addVariable (Mechanism.TIME_CONSTANTS, "startTime");
        _st.put ("endTime");
        addVariable (Mechanism.TIME_CONSTANTS, "endTime");
        _st.put ("timeStep");
        addVariable (Mechanism.TIME_CONSTANTS, "timeStep");
        _st.put ("time");
        addVariable (Mechanism.TIME_CONSTANTS, "time");
        // first output is always the time
        addVariable (Mechanism.OUTPUTS, "time");
        _st.put ("epsilon");
        addVariable (Mechanism.TIME_CONSTANTS, "epsilon");
        // constants
        _st.put ("avogadro", 6.0221367e23);
        _st.put ("boltzmann", 1.380659e-23); // in J/K
        _st.put ("gasConstant", 8.31451); // in J/(mol*K)
        _st.put ("infinity", Double.POSITIVE_INFINITY);
    } // initializer

    // create an expression for the right hand side of a power expression
    // for regular expressions, use POW, which uses Math.pow
    // but for integers, use a more efficient method (in tenua.symbol.Power)
    Expression powerExpression (Expression rhs){
        if (rhs.isConstant()){
            double val = rhs.eval(null).get(0);
            if (val == 1d){
                // x^1 == x, no return a no-op Expression
                return new Expression();
            }else if (val == Math.floor(val)){
                return new Expression (Power.getInstance((int) val));
            } // if val is an int
        } // if isConstant
        return rhs.add (Binary.POW); // the default method
    } // powerExpression

    // internal functions. "put" functions get the symbol table
    // entry if it exists, and create it if it does not
    Symbol putChemical(String s){
        putChemicalRate (s);
        addVariable (Mechanism.SPECIES, s);
        return _st.put (s);
    } // putChemical

    Symbol putChemicalRate (String s){
        s = "rate("+s+")";
        addVariable (DERIVATIVES, s);
        addVariable (Mechanism.CHEMICAL_RATES, s);
        return _st.put (s);
    } // putChemicalRate

    Symbol putRxnRate (String s){
        s = "rate("+s+")";
        addVariable (DERIVATIVES, s);
        return _st.put (s);
    } // putRxnRate

    Symbol putRateConstant (String s){
        s = "k("+s+")";
        addVariable (Mechanism.RATE_CONSTANTS, s);
        return _st.put (s);
    } // putRateConstant

    // adds a variable to the given List, with no duplicates
    void addVariable (String key, String name){
        List list = (List) _variableNames.get(key);
        if (list == null){
            list = new ArrayList();
            _variableNames.put (key, list);
        } // if
        if (!list.contains(name)) list.add (name);
    } // addVariable

    // checks if a given variable is on a given list 
    boolean isOnList (String name, String key){
        List list = (List) _variableNames.get(key);
        if (list == null) return false;
        return list.contains(name);
    } // isOnList

    // same as above, but checks for a given Symbol
    boolean isOnList (Symbol s, String key)
      {return isOnList (_st.lookup(s), key); }

    // process the reactions to add the appropriate derivative calculations
    void processReactions(){
        // if no species, no reactions
        if (_variableNames.get(Mechanism.SPECIES) == null) return;
        ReactionBlock reactions = new ReactionBlock (_rxnLHS, _rxnRHS, _st);
        // get all the reaction rates; insert them as the first calculations
        // These are placed at the beginning since the species rate
        // assignments
        // done in the mechanism description file (and thus part of
        // _derivativeCalculations) may refer to them,
        // so they have to be updated
        // before the rest of _derivativeCalculations
        for (int reaction = 1; reaction <= _rxnLHS.size(); reaction++){
            String forwardName = "rate(+"+reaction+")";
            if (!isOnList (forwardName, RATE_SET))
              _derivativeCalculations.prepend
             (reactions.reactionRate(reaction));
            String backwardName = "rate(-"+reaction+")";
            if (!isOnList (backwardName, RATE_SET))
              _derivativeCalculations.prepend
             (reactions.reactionRate(-reaction));
        } // for

        // Get the total rate calculations and append them.
        // These are intermediate values that are not accessible by the
        // mechanism description file.
        // They are created by the following line
        _derivativeCalculations.add (reactions.totalRates());
        // get all the species rates; append them as the last calcuations
        java.util.Iterator i =
          ((List) _variableNames.get(Mechanism.SPECIES)).iterator();
        while (i.hasNext()){
            String species = (String) i.next();
            String rateName = "rate("+species+")";
            if (!isOnList(rateName, RATE_SET))
              _derivativeCalculations.add (reactions.speciesRate(species));
        } // while
    } // processReactions

    // adds all the species to the output list
    void addSpeciesToOutput(){
        List species = (List)_variableNames.get(Mechanism.SPECIES);
        if (species == null) return;
        ((List)_variableNames.get(Mechanism.OUTPUTS)).addAll(species);
        for (java.util.Iterator i = species.iterator(); i.hasNext();)
            _outputExpressions.add(_st.get((String) i.next()));
    }

////////////////// Mechanism grammar
  final public Mechanism mechanism() throws ParseException, bsh.EvalError {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case EOL:
    case BANG:
    case EXP:
    case LOG:
    case ADD:
    case SUB:
    case FINAL:
    case RATE:
    case RATECONSTANT:
    case ID:
    case INT:
    case NUMBER:
    case JAVAID:
      reactionBlock();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OUTPUT_MARKER:
      outputBlock();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCRIPT_MARKER:
      scriptBlock();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    jj_consume_token(0);
        processReactions();
        if (((List)_variableNames.get(Mechanism.OUTPUTS)).size() <= 1){
            // if no outputs other than time, use the species list
            addSpeciesToOutput();
        } // if
        // remove stuff from previous calculations
        _calculations.add (Symbol.CLEAR_STACK);
        // first output data is time
        _calculations.add (_st.get("time"));
        _calculations.add (_outputExpressions);
        Mechanism mechanism = new Mechanism
              (_variableNames, _calculations, _derivativeCalculations,
           _st, _interpreter);

        _interpreter.set ("mechanism", mechanism);

        // create a global variable that we will point to the
        // closure that is the script
        // so we can refer to script variables from within the
        // mechanism as @script.variable
        // debugging line: System.out.println ("***"+_script);
        _interpreter.eval
          ("$script() { global.script = this; " + _script + "; }" );
        {if (true) return mechanism;}
    throw new Error("Missing return statement in function");
  }

  final public void reactionBlock() throws ParseException {
                         Expression e;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case BANG:
      case EXP:
      case LOG:
      case ADD:
      case SUB:
      case FINAL:
      case RATE:
      case RATECONSTANT:
      case ID:
      case INT:
      case NUMBER:
      case JAVAID:
        if (jj_2_1(2147483647)) {
          reaction();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case BANG:
          case EXP:
          case LOG:
          case ADD:
          case SUB:
          case FINAL:
          case RATE:
          case RATECONSTANT:
          case ID:
          case INT:
          case NUMBER:
          case JAVAID:
            e = expression();
                         _calculations.add(e);
            break;
          default:
            jj_la1[3] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      jj_consume_token(EOL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case EOL:
      case BANG:
      case EXP:
      case LOG:
      case ADD:
      case SUB:
      case FINAL:
      case RATE:
      case RATECONSTANT:
      case ID:
      case INT:
      case NUMBER:
      case JAVAID:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_1;
      }
    }
  }

  final public void outputBlock() throws ParseException {
                       Expression e;
    jj_consume_token(OUTPUT_MARKER);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case EOL:
      case BANG:
      case EXP:
      case LOG:
      case ADD:
      case SUB:
      case FINAL:
      case RATE:
      case RATECONSTANT:
      case ID:
      case INT:
      case NUMBER:
      case JAVAID:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case BANG:
      case EXP:
      case LOG:
      case ADD:
      case SUB:
      case FINAL:
      case RATE:
      case RATECONSTANT:
      case ID:
      case INT:
      case NUMBER:
      case JAVAID:
        e = expression();
        addVariable (Mechanism.OUTPUTS, e.toString(_st));
        _outputExpressions.add (e);
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      jj_consume_token(EOL);
    }
  }

// sets up the interpreter with the predefined methods
  final public void scriptBlock() throws ParseException {
    jj_consume_token(SCRIPT_MARKER);
    _script = script(_st);
  }

////////////////// Reaction grammar

// used for lookahead to decide if a statement is a reaction; don't
// need to look for the whole thing, just to the <REACTION_MARKER>
  final public void reactionLookahead() throws ParseException {
    side();
    jj_consume_token(REACTION_MARKER);
  }

  final public void reaction() throws ParseException {
                    List lhs, rhs, oldRHS=null;
    lhs = side();
                   _rxnLHS.add(lhs);
    label_3:
    while (true) {
      jj_consume_token(REACTION_MARKER);
      rhs = side();
            _rxnRHS.add (rhs);
            // an extended reaction; the lhs of this reaction
            // is the rhs of the last
            if (_rxnLHS.size() < _rxnRHS.size()) _rxnLHS.add(oldRHS);
            oldRHS = rhs;
            String forward =  "+" + _rxnLHS.size();
            String backward = "-" + _rxnLHS.size();
            putRxnRate (forward); putRxnRate (backward);
            putRateConstant (forward); putRateConstant (backward);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REACTION_MARKER:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
    }
  }

  final public List side() throws ParseException {
               List r, result;
    result = reactant();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ADD:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      jj_consume_token(ADD);
      r = reactant();
                             result.addAll(r);
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List reactant() throws ParseException {
    Integer i = new Integer (1); // default stoichiometry is 1
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
      t = jj_consume_token(INT);
                 i = new Integer (t.image);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    t = jj_consume_token(ID);
        List result = new ArrayList();
        result.add(i);
        result.add (putChemical (t.image));
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

////////////////// Expression grammar
  final public Expression expression() throws ParseException {
                           Expression e; Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case BANG:
    case EXP:
    case LOG:
    case ADD:
    case SUB:
    case RATE:
    case RATECONSTANT:
    case ID:
    case INT:
    case NUMBER:
    case JAVAID:
      e = assignExpression();
                             {if (true) return e;}
      break;
    case FINAL:
      jj_consume_token(FINAL);
      t = jj_consume_token(ID);
      jj_consume_token(COLON);
      e = expression();
        // the parser usually makes sure e has exactly one result.
        // a buggy <JAVAID> could leave too many or too few results
        // on the stack, but there's no
        // way to stop that. I could check e.eval.size() and throw
        // a more comprehensible exception
        {if (true) return new Expression (_st.put(t.image, e.eval(null).get(0)));}
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression assignExpression() throws ParseException {
                                Symbol op; Expression lhs, rhs;
    // left-associative; throws UnexpectedSymbolException
        // if the lhs cannot be assigned to.
        // Appends the assignment to a calculation list
        // and returns the left hand side
        // for further use
        lhs = binaryExpression(0);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
    case COLON:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUALS:
        jj_consume_token(EQUALS);
        rhs = assignExpression();
                                              // assignment in the simulation
            Assignment assignSymbol = lhs.getAssignment(_st);
            // add the assignment to the appropriate calculation list
            // and return the variable for further use
            rhs.add (assignSymbol);
            // need to check which list to add this to
            if (isOnList (assignSymbol.getTarget(), DERIVATIVES)){
                // it's a derivative assignment; put it on the right list
                addVariable (RATE_SET, lhs.toString(_st));
                _derivativeCalculations.add (rhs);
            }else{
                _calculations.add (rhs);
            }
            {if (true) return lhs;}
        break;
      case COLON:
        jj_consume_token(COLON);
        rhs = assignExpression();
                                             // assignement to default value
            Variable v = lhs.getAssignment(_st).getTarget();
            v.assign (rhs.eval (null).get(0), null);
            {if (true) return lhs;}
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
      {if (true) return lhs;}
    throw new Error("Missing return statement in function");
  }

// the precedence-climbing algorithm described by Theodore Norvell
// http://www.engr.mun.ca/~theo/Misc/exp_parsing.htm
// Basically, it uses look ahead to decide if the next
// binary operation should be parsed now
// (if its precedence is higher than the current precedence)
// If it's not parsed now, it will be caught by the recursive
// parse of rhs = binaryExpression.
// The current precedence level is passed in as minPrecedence
  final public Expression binaryExpression(int minPrecedence) throws ParseException {
   Binary op; Expression lhs, rhs;
    lhs = unaryExpression();
    label_5:
    while (true) {
      if (_binaries [getToken(1).kind] != null
                && _binaries [getToken(1).kind].precedence() >= minPrecedence) {
        ;
      } else {
        break label_5;
      }
      op = binary();
            int precedence = op.precedence();
            if (op.leftAssociative()) ++precedence;
            rhs = binaryExpression (precedence);
        if (op != Binary.POW){
                lhs.add (rhs);
                lhs.add (op);
        }else{
            // small integer powers are done efficiently; this checks
            // for that case
            lhs.add (powerExpression (rhs));
        } // if

    }
      {if (true) return lhs;}
    throw new Error("Missing return statement in function");
  }

  final public Binary binary() throws ParseException {
                  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      t = jj_consume_token(IF);
      break;
    case OR:
      t = jj_consume_token(OR);
      break;
    case AND:
      t = jj_consume_token(AND);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case LE:
      t = jj_consume_token(LE);
      break;
    case GE:
      t = jj_consume_token(GE);
      break;
    case NE:
      t = jj_consume_token(NE);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case ADD:
      t = jj_consume_token(ADD);
      break;
    case SUB:
      t = jj_consume_token(SUB);
      break;
    case MUL:
      t = jj_consume_token(MUL);
      break;
    case DIV:
      t = jj_consume_token(DIV);
      break;
    case MOD:
      t = jj_consume_token(MOD);
      break;
    case POW:
      t = jj_consume_token(POW);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return _binaries[t.kind];}
    throw new Error("Missing return statement in function");
  }

// unary expressions have higher precedence than any binary
// consistent, I believe, with Java but not with standard algebraic use
// so -x^2 parses as (-x)^2, not -(x^2)
  final public Expression unaryExpression() throws ParseException {
                                Symbol op; Expression e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
      jj_consume_token(ADD);
      e = unaryExpression();
                                  {if (true) return e;}
      break;
    case BANG:
    case EXP:
    case LOG:
    case SUB:
      op = unary();
      e = unaryExpression();
                                       e.add (op); {if (true) return e;}
      break;
    case LPAREN:
    case RATE:
    case RATECONSTANT:
    case ID:
    case INT:
    case NUMBER:
    case JAVAID:
      e = primaryExpression();
                                {if (true) return e;}
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* predefined unary operators. for any other method, use a <JAVAID> */
  final public Symbol unary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB:
      jj_consume_token(SUB);
               {if (true) return Unary.NEGATE;}
      break;
    case BANG:
      jj_consume_token(BANG);
               {if (true) return Unary.NOT;}
      break;
    case EXP:
      jj_consume_token(EXP);
               {if (true) return Unary.EXP;}
      break;
    case LOG:
      jj_consume_token(LOG);
               {if (true) return Unary.LN;}
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression primaryExpression() throws ParseException {
                                  Symbol s; Expression e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
    case NUMBER:
      s = number();
                   {if (true) return new Expression (s);}
      break;
    case ID:
      s = identifier();
                       {if (true) return new Expression (s);}
      break;
    case RATE:
      s = rate();
                 {if (true) return new Expression (s);}
      break;
    case RATECONSTANT:
      s = rateConstant();
                         {if (true) return new Expression (s);}
      break;
    case JAVAID:
      e = javaID();
                   {if (true) return e;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      e = expression();
      jj_consume_token(RPAREN);
                                         {if (true) return e;}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Symbol number() throws ParseException {
                  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
      t = jj_consume_token(INT);
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                               {if (true) return _st.put(Double.parseDouble(t.image));}
    throw new Error("Missing return statement in function");
  }

  final public Symbol identifier() throws ParseException {
                      Token t;
    t = jj_consume_token(ID);
        if (_st.get(t.image) == null){
            // not previously defined, must be a parameter
            addVariable (Mechanism.PARAMETERS, t.image);
        }
        {if (true) return _st.put (t.image);}
    throw new Error("Missing return statement in function");
  }

  final public Symbol rate() throws ParseException {
                Token t; String rxn; Symbol s;
    jj_consume_token(RATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SUB:
      rxn = reactionNumber();
                                   s = putRxnRate(rxn);
      break;
    case ID:
      t = jj_consume_token(ID);
            // make sure it's a chemical species that has a rate
            putChemical (t.image);
            s = putChemicalRate (t.image);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
      {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Symbol rateConstant() throws ParseException {
                        String rxn;
    jj_consume_token(RATECONSTANT);
    rxn = reactionNumber();
    jj_consume_token(RPAREN);
        {if (true) return _st.put( "k(" + rxn + ")");}
    throw new Error("Missing return statement in function");
  }

  final public String reactionNumber() throws ParseException {
    Token sign, t;
    int n = _rxnLHS.size();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
      sign = jj_consume_token(ADD);
      break;
    case SUB:
      sign = jj_consume_token(SUB);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
      t = jj_consume_token(INT);
                                            n = Integer.parseInt(t.image);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
        {if (true) return sign.image + Integer.toString(n);}
    throw new Error("Missing return statement in function");
  }

// javaid is JAVAID with no parentheses (a field expression),
// for which len == -1,
// or javaid(), for which len == 0,
// or javaid(args), for which len == number of arguments
// the name of the method or field is the JAVAID, without the initial '@'
  final public Expression javaID() throws ParseException {
                      Token t; Expression e=new Expression(); int len = -1;
    t = jj_consume_token(JAVAID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                            len = 0;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case BANG:
      case EXP:
      case LOG:
      case ADD:
      case SUB:
      case FINAL:
      case RATE:
      case RATECONSTANT:
      case ID:
      case INT:
      case NUMBER:
      case JAVAID:
        len = argumentList(e);
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
        e.add (new Interpreted
          (t.image.substring("@".length()), len, _interpreter));
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public int argumentList(Expression e) throws ParseException {
                                   int len = 1; Expression lhs, rhs;
    lhs = expression();
                         e.add(lhs);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
      rhs = expression();
        e.add (rhs);
        len++;
    }
      {if (true) return len;}
    throw new Error("Missing return statement in function");
  }

////////////////// Script processing
// We pass scripts almost unchanged to bsh.Interpreter, but
// we do some mangling to allow it to use mechanism variables
// We turn any <ID> that is recognized by the symbol table
// into "variable("<ID>").value, and variable is a method that
// returns a DoubleBean with getValue and setValue methods.

// To make the interpreter's error messages have line numbers corresponding
// to the original mechanism, we add the appropriate number of lines
// before the script.
// The column count will likely be wrong, but we do so much mangling
// it would be hard to get that right.
// To allow macro processing (execution of scripts with
// pre-existing SymbolTables) we pass the SymbolTable in as a variable
  final public StringBuffer script(SymbolTable st) throws ParseException {
    Token t = getToken(1);
    scriptItems(st);
        StringBuffer result = new StringBuffer();
        // add newlines to make the error messages come out right
        int beginLine = t.beginLine;
        while (--beginLine > 0) result.append("\n");
        // append each token, with the special tokens before it
        for (; t != null; t = t.next){
            // append special tokens. This appends them backwards,
            // but that's ok for whitespace
            for (Token sp = t.specialToken; sp != null; sp = sp.specialToken)
              result.append (sp.image);
            // append this token
            result.append (t.image);
        } // for
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void scriptItems(SymbolTable st) throws ParseException {
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case MULTILINE_STRING:
      case MULTILINE_STRING_PART:
      case LPAREN:
      case COMMA:
      case EOL:
      case GO:
      case NOTE:
      case DATA_METHOD:
      case SCRIPT_ID:
      case INT:
      case ANYTHING_ELSE:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_7;
      }
      scriptExpression(st);
    }
  }

  final public void scriptExpression(SymbolTable st) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GO:
      goExpression(st);
      break;
    case NOTE:
      noteExpression();
      break;
    case SCRIPT_ID:
      id(st);
      break;
    case STRING:
      string(st);
      break;
    case LPAREN:
      parenthesizedExpression(st);
      break;
    case MULTILINE_STRING:
    case MULTILINE_STRING_PART:
    case COMMA:
    case EOL:
    case DATA_METHOD:
    case INT:
    case ANYTHING_ELSE:
      anything();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

   // scriptItem

// Turn "go" into "mechanism.goSimulate()" and 
// "go varying x,y,z;" into "goVarying("x","y","z");" and
// "go varying(n) x,y,z;" into "goVaryingN((n),"x","y","z");"
  final public void goExpression(SymbolTable st) throws ParseException {
                                      Token t, t1, t2;
    t = jj_consume_token(GO);
               t.image = "mechanism.goSimulate()";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARYING:
      t1 = jj_consume_token(VARYING);
                         t.image="goVarying("; t1.image="";
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        t2 = parenthesizedExpression(st);
           t.image="goVaryingN("; t2.image="),";
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      termList();
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
  }

  // goExpression

// turn "note variables x,y,z;" into noteVariable("x","y","z");"
  final public void noteExpression() throws ParseException {
                         Token t, t1;
    t = jj_consume_token(NOTE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLES:
      t1 = jj_consume_token(VARIABLES);
      termList();
                                   t.image = "noteVariable("; t1.image="";
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
  }

  // noteExpression

// Turn x into variable("x").value where appropriate
  final public void id(SymbolTable st) throws ParseException {
                            Token t;
    t = jj_consume_token(SCRIPT_ID);
        if (st.get(t.image) != null){
            t.image = "variable(\"" + t.image + "\").value";
        } // if

  }

  // id

// Turn "data column".method into data("data column").method, and 
// "data column"(x) into data("data column").doubleBean(x).value
// Uses LOOKAHEAD(1) because <DATA_METHOD> and <LPAREN> can
// be scriptExpressions in their own rights. The default parsing
// attaching them to the <STRING> is correct; LOOKAHEAD silences the
// warning
  final public void string(SymbolTable st) throws ParseException {
                                Token t;
    t = jj_consume_token(STRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case DATA_METHOD:
      dataMethod(st, t);
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
  }

  final public void dataMethod(SymbolTable st, Token t) throws ParseException {
                                            Token t1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA_METHOD:
      jj_consume_token(DATA_METHOD);
                      t.image = "data(" + t.image + ")";
      break;
    case LPAREN:
      t1 = parenthesizedExpression(st);
            t.image = "data(" + t.image + ").doubleBean";
            t1.image = ").value";
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// returns the Token representing the closing parenthesis, so it can be modified
  final public Token parenthesizedExpression(SymbolTable st) throws ParseException {
                                                 Token t;
    jj_consume_token(LPAREN);
    scriptItems(st);
    t = jj_consume_token(RPAREN);
                                        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// id , id ;
// becomes "id" , "id" ); 
  final public void termList() throws ParseException {
                  Token t;
    t = jj_consume_token(SCRIPT_ID);
                      t.image = "\"" + t.image + "\"";
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      t = jj_consume_token(SCRIPT_ID);
                                t.image = "\"" + t.image + "\"";
    }
    t = jj_consume_token(EOL);
                t.image = ");";
  }

// anything that does not need to be mangled
// stays the same. <DATA_METHOD> is only reserved after strings
  final public void anything() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTILINE_STRING:
      jj_consume_token(MULTILINE_STRING);
      break;
    case MULTILINE_STRING_PART:
      jj_consume_token(MULTILINE_STRING_PART);
      break;
    case DATA_METHOD:
      jj_consume_token(DATA_METHOD);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      break;
    case EOL:
      jj_consume_token(EOL);
      break;
    case INT:
      jj_consume_token(INT);
      break;
    case ANYTHING_ELSE:
      jj_consume_token(ANYTHING_ELSE);
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(ADD)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_3R_10()) return true;
    if (jj_scan_token(REACTION_MARKER)) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) jj_scanpos = xsp;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  public MechanismParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[34];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x7900000,0x0,0x0,0x7100000,0x7100000,0x7900000,0x7900000,0x7100000,0x0,0x0,0x0,0x7100000,0x0,0x0,0xf8000000,0x7100000,0x7000000,0x100000,0x0,0x0,0x0,0x0,0x7100000,0x100000,0x400000,0xd30800,0xd30800,0x100000,0x0,0x0,0x100000,0x100000,0x400000,0xc30000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x59602030,0x4000,0x8000,0x59602030,0x59602030,0x59602030,0x59602030,0x59602030,0x400,0x10,0x8000000,0x59602030,0x1800,0x1800,0x3ff,0x59600030,0x20,0x59600000,0x18000000,0x1000030,0x30,0x8000000,0x59602030,0x0,0x0,0x88950000,0x88950000,0x0,0x20000,0x80000,0x100000,0x100000,0x0,0x88100000,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public MechanismParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MechanismParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MechanismParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MechanismParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MechanismParser(MechanismParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(MechanismParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 34; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[64];
    for (int i = 0; i < 64; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 34; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 64; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

      // addSpeciesToOutput

}
